local assets=
{
	Asset("ANIM", "anim/vog25.zip"),
	Asset("ATLAS", "images/inventoryimages/vog25.xml"),
    Asset("IMAGE", "images/inventoryimages/vog25.tex"),
}

local prefabs =
{
	"explode_small",
}

local function OnHit(inst, owner, target)
    inst:Remove()    
	SpawnPrefab("explode_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("vog25")
    inst.AnimState:SetBuild("vog25")
    inst.AnimState:PlayAnimation("idle", false)
    		
    inst:AddTag("projectile")
	
				
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(40)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
		
	inst:AddComponent("explosive")
    inst.components.explosive.explosivedamage = 281
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/vog25.xml"

	return inst
end



STRINGS.NAMES.vog25 = "Vog-25."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.vog25 = "Ammo for the bulldog 6."


return Prefab( "common/inventory/vog25", fncommon, assets)
